/*
 * @(#)TextChanger.java      
 *
 * Copyright (c) 1997 NAKAGAWA Masami
 *
 * Permission to use, copy, modify, and distribute this software
 * for NON-COMMERCIAL purpose and without fee is hereby granted. 
 */

import java.applet.*;
import java.awt.*;
import java.util.*;

/** A class of text changer. This class is a slave of ImageChanger.
 * @author	NAKAGAWA Masami
 * @version	2.0, 22 Jul 1997
 */
public class TextChanger extends Applet {
    private TextArea area;
    private String[] texts;
    private Color bgColor;
    private Color fgColor;

    public void init() {
        setLayout(new BorderLayout());
        area = new TextArea();
        area.setEditable(false);
        String s = getParameter("bgColor");
        if (s != null) bgColor = new Color(Integer.parseInt(s, 16));
        s = getParameter("fgColor");
        if (s != null) fgColor = new Color(Integer.parseInt(s, 16));
        area.setBackground(bgColor);
        area.setForeground(fgColor);
        add("Center", area);
        s = getParameter("texts");
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, "|");
            texts = new String[st.countTokens()];
            int count = 0;
            while (st.hasMoreTokens()) {
                String t = st.nextToken().trim();
                if (t.equals("-")) {
                    texts[count] = "";
                } else {
                    texts[count] = modifyString(t);
                }
                count++;
            }
        }
    }
    
    private String modifyString(String s) {
        StringBuffer buff = new StringBuffer();
        boolean flag = false;
        for (int i = 0; i < s.length(); i++) {
            char c = s.charAt(i);
            if (flag) {
                if (c == 'n') {
                    buff.append('\n');
                } else {
                    buff.append(c);
                }
                flag = false;
            } else if (c == '\\' || c == 0xA5) {
                flag = true;
            } else if (c != '\n') {
                buff.append(c);
                flag = false;
            }
        }
        return buff.toString();
    }
    
    public void changeText(int n) {
        if (n < texts.length) {
            area.setText(texts[n]);
        } else {
            area.setText("");
        }
    }
}